/**************************************************************************************

  Copyright (C) 2010 Hilscher Gesellschaft fr Systemautomation mbH.

  This program can be used by everyone according the "industrialNETworX Public License INPL".

  The license can be downloaded under <http://www.industrialNETworX.com>.

 **************************************************************************************

   Last Modification:
    @version $Id: ProfibusDl_diag.h 6848 2010-03-24 11:08:15Z RalfH $

   Description:
   Profibus DL Task Functionlist

   Changes:

     Date        Author        Description
     ----------------------------------------------------------------------------------
     2010-03-23  RH            Created
**************************************************************************************/
#ifndef __PROFIBUS_DL_FUNCTIONLIST_H
#define __PROFIBUS_DL_FUNCTIONLIST_H


/****************************************************************************************
* Profibus Dl, function list */

TLR_RESULT  TaskExit_ProfibusDl (TLR_VOID * pvTskRsc);
TLR_RESULT  TaskLeave_ProfibusDl(TLR_VOID * pvTskRsc, TLR_VOID * pvLeave);
TLR_RESULT  TaskEnter_ProfibusDl(TLR_VOID * pvInit);

/*************************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */
 
 
/** version of task startup parameter */
#define PROFIBUS_DL_STARTUP_PARAM_VERSION (1)


/** task startup parameter */
typedef struct PROFIBUS_DL_STARTUPPARAMETER_Ttag  PROFIBUS_DL_STARTUPPARAMETER_T;


/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */
struct PROFIBUS_DL_STARTUPPARAMETER_Ttag    /* task startup parameter */
{
  TLR_UINT32 ulTaskIdentifier; /* task identifier see TLR_TaskIdentifier.h */
  TLR_UINT32 ulParamVersion;   /* structure version     */
  
  TLR_BOOLEAN32 fRunAsMaster;
  TLR_STR *  pszXcName;     /* Name of the XC           */
  TLR_STR *  pszRpuName;    /* Name of the XMAC RPU     */
  TLR_STR *  pszTpuName;    /* Name of the XMAC TPU     */
  TLR_STR *  pszPFifoName;  /* Name of the Pointer Fifo */
};

/** @} */


  /*
  ******************************************************************************
  *  Profibus XC Configuration                                                 *
  ******************************************************************************
  */
  extern UINT32 XcCode_xpec_pb0;
  extern UINT32 XcCode_xpec_pb1;
  extern UINT32 XcCode_xpec_pb2;
  extern UINT32 XcCode_xpec_pb3;

  extern UINT32 XcCode_rpu_pb0;
  extern UINT32 XcCode_rpu_pb1;
  extern UINT32 XcCode_rpu_pb2;
  extern UINT32 XcCode_rpu_pb3;

  extern UINT32 XcCode_tpu_pb0;
  extern UINT32 XcCode_tpu_pb1;
  extern UINT32 XcCode_tpu_pb2;
  extern UINT32 XcCode_tpu_pb3;

  /* note: backward compabilty to old defines: Master and slave are the same C-symbols (same code)! */

  #define XC_CODE_PROFIBUS_SLAVE_XPEC0 ((UINT32 *)&XcCode_xpec_pb0)
  #define XC_CODE_PROFIBUS_SLAVE_XPEC1 ((UINT32 *)&XcCode_xpec_pb1)
  #define XC_CODE_PROFIBUS_SLAVE_XPEC2 ((UINT32 *)&XcCode_xpec_pb2)
  #define XC_CODE_PROFIBUS_SLAVE_XPEC3 ((UINT32 *)&XcCode_xpec_pb3)
  
  #define XC_CODE_PROFIBUS_SLAVE_RPU0 ((UINT32 *)&XcCode_rpu_pb0)
  #define XC_CODE_PROFIBUS_SLAVE_RPU1 ((UINT32 *)&XcCode_rpu_pb1)
  #define XC_CODE_PROFIBUS_SLAVE_RPU2 ((UINT32 *)&XcCode_rpu_pb2)
  #define XC_CODE_PROFIBUS_SLAVE_RPU3 ((UINT32 *)&XcCode_rpu_pb3)
  
  #define XC_CODE_PROFIBUS_SLAVE_TPU0 ((UINT32 *)&XcCode_tpu_pb0)
  #define XC_CODE_PROFIBUS_SLAVE_TPU1 ((UINT32 *)&XcCode_tpu_pb1)
  #define XC_CODE_PROFIBUS_SLAVE_TPU2 ((UINT32 *)&XcCode_tpu_pb2)
  #define XC_CODE_PROFIBUS_SLAVE_TPU3 ((UINT32 *)&XcCode_tpu_pb3)

 
  #define XC_CODE_PROFIBUS_MASTER_XPEC0 ((UINT32 *)&XcCode_xpec_pb0)
  #define XC_CODE_PROFIBUS_MASTER_XPEC1 ((UINT32 *)&XcCode_xpec_pb1)
  #define XC_CODE_PROFIBUS_MASTER_XPEC2 ((UINT32 *)&XcCode_xpec_pb2)
  #define XC_CODE_PROFIBUS_MASTER_XPEC3 ((UINT32 *)&XcCode_xpec_pb3)
  
  #define XC_CODE_PROFIBUS_MASTER_RPU0 ((UINT32 *)&XcCode_rpu_pb0)
  #define XC_CODE_PROFIBUS_MASTER_RPU1 ((UINT32 *)&XcCode_rpu_pb1)
  #define XC_CODE_PROFIBUS_MASTER_RPU2 ((UINT32 *)&XcCode_rpu_pb2)
  #define XC_CODE_PROFIBUS_MASTER_RPU3 ((UINT32 *)&XcCode_rpu_pb3)
  
  #define XC_CODE_PROFIBUS_MASTER_TPU0 ((UINT32 *)&XcCode_tpu_pb0)
  #define XC_CODE_PROFIBUS_MASTER_TPU1 ((UINT32 *)&XcCode_tpu_pb1)
  #define XC_CODE_PROFIBUS_MASTER_TPU2 ((UINT32 *)&XcCode_tpu_pb2)
  #define XC_CODE_PROFIBUS_MASTER_TPU3 ((UINT32 *)&XcCode_tpu_pb3)
  
  /* or use the new defines, which also does the same */
  
  #define XC_CODE_PROFIBUS_XPEC0 ((UINT32 *)&XcCode_xpec_pb0)
  #define XC_CODE_PROFIBUS_XPEC1 ((UINT32 *)&XcCode_xpec_pb1)
  #define XC_CODE_PROFIBUS_XPEC2 ((UINT32 *)&XcCode_xpec_pb2)
  #define XC_CODE_PROFIBUS_XPEC3 ((UINT32 *)&XcCode_xpec_pb3)
  
  #define XC_CODE_PROFIBUS_RPU0 ((UINT32 *)&XcCode_rpu_pb0)
  #define XC_CODE_PROFIBUS_RPU1 ((UINT32 *)&XcCode_rpu_pb1)
  #define XC_CODE_PROFIBUS_RPU2 ((UINT32 *)&XcCode_rpu_pb2)
  #define XC_CODE_PROFIBUS_RPU3 ((UINT32 *)&XcCode_rpu_pb3)
  
  #define XC_CODE_PROFIBUS_TPU0 ((UINT32 *)&XcCode_tpu_pb0)
  #define XC_CODE_PROFIBUS_TPU1 ((UINT32 *)&XcCode_tpu_pb1)
  #define XC_CODE_PROFIBUS_TPU2 ((UINT32 *)&XcCode_tpu_pb2)
  #define XC_CODE_PROFIBUS_TPU3 ((UINT32 *)&XcCode_tpu_pb3)


/***************************************************************************************/
#endif /* #ifndef __PROFIBUS_DL_FUNCTIONLIST_H */
